<?php

class ReviewSiteLayout extends ReviewSiteLayoutApp
{	
	var $data;
	var $value;
	var $status;
	var $prefix	= "reviewsite_";
	var $bg_repeat	= array(
							"no-repeat"	=> "no-repeat",
							"repeat-x"	=> "repeat-x",
							"repeat-y"	=> "repeat-y",
							"repeat"	=> "repeat"
						  );
	var $yn_options		= array(
							'yes'	=> 'yes',
							"no"	=> 'no',
						  );
	
	// init
	function init()
	{
		add_action("admin_menu",array(&$this,"createMenu"));
	}
	
	// create menu
	function createMenu()
	{
		add_submenu_page( 'reviewSite', 'ReviewSite Service &bull; Theme Layout', 'Theme Layout', 'manage_categories', 'reviewSite-layout', array(&$this,"view"));
	}
	
	/*==================================================================================*/
	/*=========================			  CONTROLLER		   =========================*/
	/*==================================================================================*/
	
	// processing Input
	function processingInput()
	{
	
		if(isset($_POST['data']) && isset($_POST['_wpnonce'])) :
			check_admin_referer('reviewSite-update-theme-layout');
			$this->data	= $_POST['data'];
			
			if(isset($_POST['savethis'])) :
				$this->updateData();
			elseif(isset($_POST['restore'])) :
			
				$this->deleteData();
			endif;
		endif;
	}
	
	// generate value from custom options
	function generateValue()
	{
		
		$this->value	= array(
			'top'		=> array(
				'background'			=> stripslashes(get_option($this->prefix.'css_top_background')),
				'border_shadow'			=> stripslashes(get_option($this->prefix.'css_top_border_shadow')),
				'link_color'			=> stripslashes(get_option($this->prefix.'css_top_link_color')),
				'hover_color'			=> stripslashes(get_option($this->prefix.'css_top_hover_color')),
				'text_bg_color'			=> stripslashes(get_option($this->prefix.'css_top_text_bg_color')),
				'text_bg_hover_color'	=> stripslashes(get_option($this->prefix.'css_top_text_bg_hover_color')),				
			),		
		
			'header'	=> array(
				'background'	=> stripslashes(get_option($this->prefix.'css_header_background')),
			),
			'post'	=> array(
				'background'	=> stripslashes(get_option($this->prefix.'css_post_background')),
				'text_color'	=> stripslashes(get_option($this->prefix.'css_post_text_color')),
			),			
			'widget'	=> array(
				'background'	=> stripslashes(get_option($this->prefix.'css_widget_background')),
				'text_color'	=> stripslashes(get_option($this->prefix.'css_widget_text_color')),
				'link_color'	=> stripslashes(get_option($this->prefix.'css_widget_link_color')),
				'hover_color'	=> stripslashes(get_option($this->prefix.'css_widget_hover_color')),				
			),			

			'footer'	=> array(
				'background'	=> stripslashes(get_option($this->prefix.'css_footer_background')),
				'link_color'	=> stripslashes(get_option($this->prefix.'css_footer_link_color')),
				'hover_color'	=> stripslashes(get_option($this->prefix.'css_footer_hover_color')),				
			)
		);		
		//echo("generate value : ");print_r($this->value);echo("<br /><br />");
	}
	
	// updateData
	function updateData()
	{
		$array_keys	= array_keys($this->data);
		
		foreach($array_keys as $key) :
			update_option($key,$this->data[$key]);
		endforeach;
		
		$this->status	= "update";
	}
	
	function deleteData()
	{
		$array_keys	= array_keys($this->data);
		
		foreach($array_keys as $key) :
			delete_option($key);
		endforeach;
		
		$this->status	= "delete";
	}
	
	/*==================================================================================*/
	/*=========================				VIEW			   =========================*/
	/*==================================================================================*/
	
	// notification
	function notification()
	{
		$this->processingInput();
		$this->generateValue();
		
		if($this->status == "update") :
		?><div class="message updated fade"><p>Settings have been updated</p></div><?php
		elseif($this->status == 'delete') :
		?><div class="message updated fade"><p>Settings have been reseted to default</p></div><?php
		endif;
	}
	
	// view
	function view()
	{
		$this->notification();
		
		?>
        <div id="reviewSite-body" class="wrap">
        	<h2>ReviewSite Theme Layout</h2>
            
			<form name="form1" method="post" action="">
            
            <?php
			//==========================================================================================//
			//======================					 Top   			      ======================//
			//==========================================================================================//
			?>
            
			<div class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Top</h3>
                    
                    <div class="inside">
						<?php parent::generateBackgroundColor('Text Link Color'				,'top','link_color'	,$this->value['top']['link_color']); ?>
						<?php parent::generateBackgroundColor('Text Hover Color'			,'top','hover_color',$this->value['top']['hover_color']); ?>
						<?php parent::generateBackgroundColor('Link Background Color'		,'top','text_bg_color',$this->value['top']['text_bg_color']); ?>
						<?php parent::generateBackgroundColor('Link Background Hover Color'	,'top','text_bg_hover_color',$this->value['top']['text_bg_hover_color']); ?>
						<?php parent::generateBackgroundColor('Background Color'			,'top','background',$this->value['top']['background']); ?>
						<?php parent::generateBackgroundColor('Border Shadow Color'			,'top','border_shadow',$this->value['top']['border_shadow']); ?>
					</div>
                    
				</div>    
                
			</div>
            
            <?php
			//==========================================================================================//
			//======================					 HEADER   			      ======================//
			//==========================================================================================//
			?>
            
			<div class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Header</h3>
                    
                    <div class="inside">
						<?php parent::generateBackgroundColor('Background Color','header','background',$this->value['header']['background']); ?>
					</div>
                    
				</div>    
                
			</div>
            
            <?php
			//==========================================================================================//
			//======================				    POST  			      ======================//
			//==========================================================================================//
			?>
			<div class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Post</h3>
                    
                    <div class="inside">
					<?php parent::generateBackgroundColor('Text Color'		,'post','text_color',$this->value['post']['text_color']); ?>
					<?php parent::generateBackgroundColor('Background Color','post','background',$this->value['post']['background']); ?>
					</div>    
				</div>    
			</div>
            <?php
			//==========================================================================================//
			//======================				    WIDGET  			      ======================//
			//==========================================================================================//
			?>
            
			<div class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Widget</h3>
                    
                    <div class="inside">
					<?php parent::generateBackgroundColor('Text Color'		,'widget','text_color',$this->value['widget']['text_color']); ?>
					<?php parent::generateBackgroundColor('Text Link Color'	,'widget','link_color',$this->value['widget']['link_color']); ?>
					<?php parent::generateBackgroundColor('Text Hover Color','widget','hover_color',$this->value['widget']['hover_color']); ?>                    
					<?php parent::generateBackgroundColor('Background Color','widget','background',$this->value['widget']['background']); ?>
					</div>    
				</div>    
			</div>
            
            <?php
			//==========================================================================================//
			//======================				    FOOTER  			      ======================//
			//==========================================================================================//
			?>
            
			<div class="metabox-holder ReviewSite-body"  style="width:90% !important;">
				<div class="postbox">
                	<h3>Footer</h3>
                    
                    <div class="inside">
					<?php parent::generateBackgroundColor('Text Link Color'	,'footer','link_color',$this->value['footer']['link_color']); ?>
					<?php parent::generateBackgroundColor('Text Hover Color','footer','hover_color',$this->value['footer']['hover_color']); ?>                    
					<?php parent::generateBackgroundColor('Background Color','footer','background',$this->value['footer']['background']); ?>
					</div>    
				</div>    
			</div>
            
            <div class="input-button" style="clear:both;">
	            <?php wp_nonce_field('reviewSite-update-theme-layout'); ?>
                <input type="submit" class="button-primary" name="savethis" value="<?php _e('Save Settings', 'ReviewSite') ?>" />
                <input type="submit" id="restore-button" class="button-primary" name="restore" value="<?php _e('Restore To Default', 'ReviewSite') ?>" />
            </div>
		
			</form>
            
            <script type="text/javascript" language="javascript1.2">
				jQuery(document).ready(function() {
					jQuery('.color-picker').jPicker();
					jQuery('#restore-button').click(function(){
						if(confirm('This action will delete all style values, are you sure?')) { return true; }
						else { return false; }
					});
				});
			</script>
        </div>
        
        <?php
	}
}

$reviewsite_layout	= new ReviewSiteLayout;
$reviewsite_layout->init();

function reviewSiteGetStyle($name,$atribute,$type = 'color',$important = true)
{
	global $th_pre;
	
	$value	= reviewSiteGetOption($name);
	
	if(!empty($value)) :
		switch($type) :
			case 'color'	: echo $atribute." : #".$value;
							  break;
		endswitch;
		
		if($important) { echo "!important"; }
		echo(';');
	endif;
	
}

?>